(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     17566,        568]*)
(*NotebookOutlinePosition[     18702,        606]*)
(*  CellTagsIndexPosition[     18658,        602]*)
(*WindowFrame->Normal*)



Notebook[{


Cell[CellGroupData[{Cell[TextData[
"Linearly Independent Functions"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This discussion of linearly independent functions pertains primarily to \
collections of functions which are ",
  StyleBox[
  "all solutions of the same homogeneous linear differential equation",
    FontVariations->{"Underline"->True}],
  ". We present the Wronskian matrix and determinant and show why these are \
important for testing for independence in this context. Some questions are \
raised which should cause you to have to think."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[TextData["The Wronskian Matrix & Determinant: Definition"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[TextData["A working set of functions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Define a sample set of three functions:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[{
    \(Clear[funs, y, k]\), 
    \(funs[x_] = Table[\(y[k]\)[x], {k, 1, 3}]\)}], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(y[1]\)[x], \(y[2]\)[x], \(y[3]\)[x]}\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["The Wronskian Matrix and Determinant"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData["Define the Wronskian matrix (general definition):"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(WMatrix[x_, z_List] := 
      Table[\[PartialD]\_{x, i}z, {i, 0, Length[z] - 1}]\)], "Input",
  AspectRatioFixed->False],

Cell[TextData[
"...And the Wronskian determinant (general definition):"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(WDet[x_, z_List] := Det[WMatrix[x, z]]\)], "Input",
  AspectRatioFixed->False],

Cell[TextData[
"General::spell1: \n   Possible spelling error: new symbol name \"WDet\"\n    \
 is similar to existing symbol \"Det\"."], "Message",
  Evaluatable->False,
  AspectRatioFixed->True]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData[
"The Wronskian Matrix of our Working Set of Functions"], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[
"Here is our Wronskian matrix (we show the determinant later on some \
examples):"], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(MatrixForm[work[x_] = WMatrix[x, funs[x]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", GridBox[{
            {\(\(y[1]\)[x]\), \(\(y[2]\)[x]\), \(\(y[3]\)[x]\)},
            {
              RowBox[{
                SuperscriptBox[\(y[1]\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox[\(y[2]\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox[\(y[3]\), "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]},
            {
              RowBox[{
                SuperscriptBox[\(y[1]\), "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox[\(y[2]\), "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              RowBox[{
                SuperscriptBox[\(y[3]\), "\[DoublePrime]",
                  MultilineFunction->None], "[", "x", "]"}]}
            }], ")"}],
      (MatrixForm[ #]&)]], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Linear Independence and the Wronskian Determinant"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Given a set ",
  StyleBox["S",
    FontWeight->"Bold"],
  " of functions which are all solutions of the same homogeneous linear \
differential equation, the functions are ",
  StyleBox["linearly independent on an interval [a, b]",
    FontVariations->{"Underline"->True}],
  " if and only if \n ",
  StyleBox["WDet[x, S] != 0",
    FontWeight->"Bold"],
  " for any x in [a, b].  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "When the functions are ",
  StyleBox["not",
    FontVariations->{"Underline"->True}],
  " the solutions of the same linear differential equation, there are \
examples where the functions are independent, but WDet[x, example]==0.  We \
will not encounter this situation. \n\nIn later sections, we will see that in \
each example the functions are solutions of the same homogeneous differential \
equation."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["Examples"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[TextData["  {Cos[a x], Sin[a x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(WMatrix[x, {Cos[a\ x], Sin[a\ x]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{Cos[a\ x], Sin[a\ x]}, {\(-\((a\ Sin[a\ x])\)\), a\ Cos[a\ x]}}\)], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(WDet[x, {Cos[a\ x], Sin[a\ x]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(a\ Cos[a\ x]\^2 + a\ Sin[a\ x]\^2\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(TrigCanonical[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(a\ Cos[a\ x]\^2 + a\ Sin[a\ x]\^2\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{Sin[a x], Cos[a x]}",
    FontWeight->"Bold"],
  " is independent except when a==0. (Why is the set dependent when a==0?)"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["  {Exp[a x], Exp[b x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(WMatrix[x, {Exp[a\ x], Exp[b\ x]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{E\^\(a\ x\), E\^\(b\ x\)}, {a\ E\^\(a\ x\), b\ E\^\(b\ x\)}}\)], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(WDet[x, {Exp[a\ x], Exp[b\ x]}]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\((a\ E\^\(a\ x + b\ x\))\)\) + b\ E\^\(a\ x + b\ x\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\((\(-a\) + b)\)\ E\^\(\((a + b)\)\ x\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{Exp[a x], Exp[b x]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is independent except when a==b."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData[
"  {Exp[a x], x Exp[a x], x^2 Exp[a x], x^3 Exp[a x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[
      WDet[x, {Exp[a\ x], x\ Exp[a\ x], x\^2\ Exp[a\ x], x\^3\ Exp[a\ x]}]]
      \)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(12\ E\^\(4\ a\ x\)\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{Exp[a x],x Exp[a x],x^2 Exp[a x],x^3 Exp[a x]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is independent. This property extends to more functions involving \
increasing powers of x (none repeated)."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["  {p[x] Exp[a x], q[x] Exp[a x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[WDet[x, {p[x]\ Exp[a\ x], q[x]\ Exp[a\ x]}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(E\^\(2\ a\ x\)\), " ", 
      RowBox[{"(", 
        RowBox[{
          RowBox[{"-", 
            RowBox[{"(", 
              RowBox[{\(q[x]\), " ", 
                RowBox[{
                  SuperscriptBox["p", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], ")"}]}], "+",
           
          RowBox[{\(p[x]\), " ", 
            RowBox[{
              SuperscriptBox["q", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], ")"}]}]], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{p[x] Exp[a x], q[x] Exp[a x]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is independent except when ",
  StyleBox["q'[x]/q[x]==p'[x]/p[x]",
    FontWeight->"Bold"],
  ", i.e., except when ",
  StyleBox["p[x]==C q[x]",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["  {p[x] Exp[a x], q[x] Exp[b x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[WDet[x, {p[x]\ Exp[a\ x], q[x]\ Exp[b\ x]}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(E\^\(\((a + b)\)\ x\)\), " ", 
      RowBox[{"(", 
        RowBox[{\(-\((a\ p[x]\ q[x])\)\), "+", \(b\ p[x]\ q[x]\), "-", 
          RowBox[{\(q[x]\), " ", 
            RowBox[{
              SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{\(p[x]\), " ", 
            RowBox[{
              SuperscriptBox["q", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], ")"}]}]], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "To analyze this, divide each term of the large factor by ",
  StyleBox["p[x]*q[x]",
    FontWeight->"Bold"],
  ", and ask when the result is 0:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    RowBox[{\((#1\/\(p[x]\ q[x]\)&)\), "/@", 
      RowBox[{"(", 
        RowBox[{\(a\ p[x]\ q[x]\), "-", \(b\ p[x]\ q[x]\), "+", 
          RowBox[{\(q[x]\), " ", 
            RowBox[{
              SuperscriptBox["p", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{\(p[x]\), " ", 
            RowBox[{
              SuperscriptBox["q", "\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}]}], ")"}]}]], 
  "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{"a", "-", "b", "+", 
      FractionBox[
        RowBox[{
          SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], \(p[x]\)], "-", 
      FractionBox[
        RowBox[{
          SuperscriptBox["q", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], \(q[x]\)]}]], "Output",\

  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "This is 0  when ",
  StyleBox["p[x]=C q[x]*Exp[(b-a)x]",
    FontWeight->"Bold"],
  ". (Why? [Set the expression ==0 and integrate each term.]) To see what \
this says, consider this substitution:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[p[x]\ Exp[a\ x] /. p[x] \[Rule] C\ q[x]\ Exp[\((b - a)\)\ x]]
      \)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(C\ E\^\(b\ x\)\ q[x]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{p[x] Exp[a x],q[x] Exp[a x]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is independent except when ",
  StyleBox["p[x]",
    FontWeight->"Bold"],
  " would convert ",
  StyleBox["p[x] Exp[a x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " into a multiple of the other function."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[TextData["  {p[x] Cos[a x], q[x] Sin[a x]}"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[WDet[x, {p[x]\ Cos[a\ x], q[x]\ Sin[a\ x]}]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(a\ p[x]\ q[x]\), "-", 
      RowBox[{\(1\/2\), " ", \(q[x]\), " ", \(Sin[2\ a\ x]\), " ", 
        RowBox[{
          SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(1\/2\), " ", \(p[x]\), " ", \(Sin[2\ a\ x]\), " ", 
        RowBox[{
          SuperscriptBox["q", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[CellGroupData[{Cell[BoxData[
    \(TrigCanonical[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(a\ p[x]\ q[x]\), "-", 
      RowBox[{\(1\/2\), " ", \(q[x]\), " ", \(Sin[2\ a\ x]\), " ", 
        RowBox[{
          SuperscriptBox["p", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{\(1\/2\), " ", \(p[x]\), " ", \(Sin[2\ a\ x]\), " ", 
        RowBox[{
          SuperscriptBox["q", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "To analyse this, divide each term by ",
  StyleBox["p[x]q[x]Cos[a x]Sin[a x],",
    FontWeight->"Bold"],
  " and ask when this is 0:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(\((#1\/\(p[x]\ q[x]\ Cos[a\ x]\ Sin[a\ x]\)&)\)/@%\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    RowBox[{\(a\ Csc[a\ x]\ Sec[a\ x]\), "-", 
      FractionBox[
        RowBox[{
        \(Csc[a\ x]\), " ", \(Sec[a\ x]\), " ", \(Sin[2\ a\ x]\), " ", 
          RowBox[{
            SuperscriptBox["p", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], \(2\ p[x]\)], "+", 
      
      FractionBox[
        RowBox[{
        \(Csc[a\ x]\), " ", \(Sec[a\ x]\), " ", \(Sin[2\ a\ x]\), " ", 
          RowBox[{
            SuperscriptBox["q", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], \(2\ q[x]\)]}]], 
  "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "This is 0  when ",
  StyleBox["p[x]=C q[x]* Tan[a x]",
    FontWeight->"Bold"],
  ". (Why? [Again set ==0 and integrate.]) To see what this says, consider \
this substitution:"
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{Cell[BoxData[
    \(Simplify[
      p[x]\ Cos[a\ x] /. p[x] \[Rule] \(C\ q[x]\ Sin[a\ x]\)\/Cos[a\ x]]\)], 
  "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(C\ q[x]\ Sin[a\ x]\)], "Output",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]],

Cell[TextData[{
  "Hence ",
  StyleBox["{p[x] Cos[a x], q[x] Sin[a x]}",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " is independent except when ",
  StyleBox["p[x]",
    FontWeight->"Bold"],
  " would convert ",
  StyleBox["p[x] Cos[a x]",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " into a multiple of the other function."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False]}, Open]]}, Open]],

Cell[CellGroupData[{Cell[TextData["Initialization"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Needs["\<Algebra`Trigonometry`\>"]\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->False]}, Open]]}, Open]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{520, 365},
WindowMargins->{{28, Automatic}, {15, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding",
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]



(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 110, 3, 70, "Subtitle"],
Cell[1844, 56, 521, 11, 70, "Text"],

Cell[CellGroupData[{
Cell[2388, 69, 124, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[2535, 73, 110, 2, 70, "Subsubsection"],
Cell[2648, 77, 114, 2, 70, "Text"],

Cell[CellGroupData[{
Cell[2785, 81, 130, 3, 70, "Input"],
Cell[2918, 86, 122, 3, 70, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3081, 91, 120, 2, 70, "Subsubsection"],
Cell[3204, 95, 124, 2, 70, "Text"],
Cell[3331, 99, 140, 3, 70, "Input"],
Cell[3474, 104, 130, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[3627, 109, 98, 2, 70, "Input"],
Cell[3728, 113, 196, 4, 70, "Message"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3965, 119, 137, 3, 70, "Subsubsection"],
Cell[4105, 124, 156, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[4284, 130, 102, 2, 70, "Input"],
Cell[4389, 134, 1101, 27, 70, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5540, 163, 127, 2, 70, "Section"],
Cell[5670, 167, 460, 14, 70, "Text"],
Cell[6133, 183, 485, 11, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[6650, 196, 86, 2, 70, "Section"],

Cell[CellGroupData[{
Cell[6759, 200, 103, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[6885, 204, 94, 2, 70, "Input"],
Cell[6982, 208, 151, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7165, 214, 91, 2, 70, "Input"],
Cell[7259, 218, 116, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7407, 223, 76, 2, 70, "Input"],
Cell[7486, 227, 116, 3, 70, "Output"]
}, Closed]],
Cell[7614, 232, 224, 7, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[7870, 241, 103, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[7996, 245, 94, 2, 70, "Input"],
Cell[8093, 249, 148, 4, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8273, 255, 91, 2, 70, "Input"],
Cell[8367, 259, 139, 3, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8538, 264, 71, 2, 70, "Input"],
Cell[8612, 268, 122, 3, 70, "Output"]
}, Closed]],
Cell[8746, 273, 213, 8, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[8991, 283, 134, 3, 70, "Subsection"],

Cell[CellGroupData[{
Cell[9148, 288, 152, 4, 70, "Input"],
Cell[9303, 294, 101, 3, 70, "Output"]
}, Closed]],
Cell[9416, 299, 315, 9, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[9763, 310, 113, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[9899, 314, 113, 2, 70, "Input"],
Cell[10015, 318, 578, 17, 70, "Output"]
}, Closed]],
Cell[10605, 337, 365, 14, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[11002, 353, 113, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[11138, 357, 113, 2, 70, "Input"],
Cell[11254, 361, 554, 14, 70, "Output"]
}, Closed]],
Cell[11820, 377, 224, 7, 70, "Text"],

Cell[CellGroupData[{
Cell[12067, 386, 525, 13, 70, "Input"],
Cell[12595, 401, 404, 12, 70, "Output"]
}, Closed]],
Cell[13011, 415, 277, 8, 70, "Text"],

Cell[CellGroupData[{
Cell[13311, 425, 137, 3, 70, "Input"],
Cell[13451, 430, 103, 3, 70, "Output"]
}, Closed]],
Cell[13566, 435, 407, 15, 70, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[14005, 452, 113, 2, 70, "Subsection"],

Cell[CellGroupData[{
Cell[14141, 456, 113, 2, 70, "Input"],
Cell[14257, 460, 486, 11, 70, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[14775, 473, 76, 2, 70, "Input"],
Cell[14854, 477, 486, 11, 70, "Output"]
}, Closed]],
Cell[15352, 490, 213, 7, 70, "Text"],

Cell[CellGroupData[{
Cell[15588, 499, 110, 2, 70, "Input"],
Cell[15701, 503, 626, 17, 70, "Output"]
}, Closed]],
Cell[16339, 522, 256, 8, 70, "Text"],

Cell[CellGroupData[{
Cell[16618, 532, 145, 4, 70, "Input"],
Cell[16766, 538, 101, 3, 70, "Output"]
}, Closed]],
Cell[16879, 543, 408, 15, 70, "Text"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17328, 560, 92, 2, 70, "Section"],
Cell[17423, 564, 122, 3, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)
